%% Sample Frequency Response Modeling
% Collected load speed data given sine wave frequency and amplitude
%wl_meas = max(wl(:,2))
% High-Gear
data = [ 
%   f (Hz)  Av (A)  wl (rad/s) 
    0.0     0.15    3.4770;
    0.25    0.15    3.0582;    
    0.5     0.15    2.2401
    0.75    0.15    1.8554
    1.0     0.15    1.4220;
    1.5     0.15    1.0470;
    2.0     0.15    0.7792;
    2.5     0.15    0.6039;
    3.0     0.15    0.5211;
    3.5     0.15    0.4383;
    4.0     0.15    0.3652;
    4.5     0.15    0.3214;
    5.0     0.15    0.2971;
    ];
%
%% Calculate frequency response
n = length(data);
% Frequency (Hz)
f = data(2:n,1);
% Gain (rad/s/V): |G(w)| = |wl(w)| / |Vm(w)|
G = abs(data(2:n,3)) ./ abs(data(2:n,2));
% Gain (dB)
Gdb = 20*log10(G);
%
%% Find gain
% Steady-state gain (rad/s/V)
Ke_f = data(1,3) / data(1,2);
Ke_f_db = 20*log10(Ke_f);
%
%% Find time constant
% Min, max, and differential frequencies (Hz)
f_min = min(f);
f_max = max(f);
df = 0.01;
% Interpolation frequency (Hz)
fi = f_min:df:f_max;
% Interpolated gain (rad/s/V)
Gi = interp1(f,G,fi,'linear');
% Interpolated gain (dB)
Gi_db = 20*log10(Gi);
% 3 dB Gain (rad/s/V)
G3_db = Ke_f_db - 3;
% 3 dB Frequency (Hz)
ic = min( find(Gi_db < G3_db) );
fc = fi(ic);
% Experimentally derived time constant (s)
tau_e_f = 1 / (2 * pi * fc);
%
%% Bode plot
semilogx(f,Gdb,'bx',fi,Gi_db,'r-');
axis([0 10 0 30]);
line( [0.1 fc], [G3_db G3_db], 'LineStyle', ':', 'Color', 'k' );
text( 0.12, 25.5, '|G(\omega_c)' )
line( [fc fc], [0 G3_db], 'LineStyle', ':', 'Color', 'k' );
text( 1.05*fc, 1, '\omega_c' )
xlabel('f (Hz)')
ylabel('|G(\omega)|_{dB}');
%
%% Display data
disp( 'SRV02 model parameters derived using manual frequency response: ' )
disp( [ '   Ke_f = ' num2str( Ke_f, 3 ) ' rad/s/V' ] )
disp( [ '   tau_e_f = ' num2str( tau_e_f, 3 ) ' s' ] )